﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;


namespace DWL4x00XY_Program
{
    public partial class MainPage : Form
    {
        static private SerialPort ComPort_RS232 = new SerialPort();
        private delegate void SetTextDeleg(byte[] text);

        vibrometer vibrograph = new vibrometer();
        public int SetProgramMode;
        public int ResProgramMode;
        public byte SensorModel;
        public int ProgramModeCheckKey;
        public int Stand;
        public int Mode;
        public int ConnectedModel;
        public bool ProgramModeReady;
        public bool SensorInitSuccess;
        public bool SensorNotInit;
        public bool InitModeCmd;
        public bool FastResponseTrig;
        public bool AutoChangeScreenAfterCalibration;
        public bool error_sending;
        public bool ACC_X_Levelled, ACC_Y_Levelled;
        public float ACC_Multiplyer;
        public double Acc_Zero_Limit;
        public int AccuracyAxis;
        int sensor_vibroValue = 0;

        public float RealAngleX, RealAngleAcc;
        public float RealAngle__Y, RealAngle__X, RealArcsec__X, RealArcsec__Y;

        public byte[] outbuffer = new byte[12];
        public byte[] inbuffer = new byte[12];

        public const int SensorInitCmd = 0x06;
        public const int SensorInitAck = 0x24;

        private const int totalbyte = 12;    // number of UART buffer (have to match with F.W)
        private const int timeout = 50;
        
        public const int PM_DUMMY = 0;          // make sure same with FW
        public const int PM_ANGLE_SINGLE = 1;
        public const int PM_ANGLE_DUAL = 2;
        public const int PM_VIBRO = 3;
        public const int PM_SERIAL = 6;
        public const int PM_CALIBRATION = 11;
        public const int PM_ALT_ZERO_SET_SINGLE = 7;
        public const int PM_LOCATION_SET = 8;
        public const int PM_SYSTEM_STATUS = 9;
        public const int PM_INIT_STANDALONE = 0x59;

        // Program Mode Checking Keys (use with Mode checking timer)
        public const int ProgramModeChecking = 0x20;

        public static bool direct_from_sensor = false;

        public static int country_index = 0;
        public static int city_index = 0;

        public const int APP_LOC_WRITE_IN_CMD = 0x5A;
        public const int APP_LOC_READ_REQ_CMD = 0x50;

        /****************************************************************************************************************************
         *         MAIN                                                                                                             *
        ******************************************************************************************************************************/
        public MainPage()
        {
            InitializeComponent();
        }

        private void Main_Load(object sender, EventArgs e)
        {
            string[] theSerialPortNames = System.IO.Ports.SerialPort.GetPortNames();
            int com_port_count;
            com_port_count = theSerialPortNames.Count();

            for (int i = 0; i < com_port_count; i++)
            {
                comboBox_COMPort_List.Items.Add(theSerialPortNames[i]);
            }
            Acc_Zero_Limit = 0.002;
            tab_DeviceScreen.Visible = false;
        }

        private void comboBox_COMPort_list_SelectedIndexChanged(object sender, EventArgs e)
        {
            ComPort_RS232.PortName = comboBox_COMPort_List.SelectedItem.ToString();
            Button_Open_COMPort.Enabled = true;
        }


        private void Button_Open_COMPort_Click(object sender, EventArgs e)
        {
            try
            {
                if (!ComPort_RS232.IsOpen)
                {
                    ComPort_RS232.BaudRate = 115200;
                    ComPort_RS232.Parity = Parity.None;
                    ComPort_RS232.DataBits = 8;
                    ComPort_RS232.StopBits = StopBits.One;
                    ComPort_RS232.Handshake = Handshake.None;
                    ComPort_RS232.DataReceived += new SerialDataReceivedEventHandler(sp_DataReceived);
                    ComPort_RS232.Open();
  
                    COMPortStatus.Text = "Status: Serial Port is ready";

                    groupBox_Model.Visible = true;
                    direct_from_sensor = true;
                    outbuffer[0] = SensorInitCmd;  
                    outbuffer[1] = SensorInitAck;

                    WriteToComPort();
                }
                else
                {
                    comboBox_COMPort_List.Enabled = false;
                }
            }
            catch (Exception ex)
            {
                COMPortStatus.Text = ex.Message;
            }

        }

        void sp_DataReceived(object sender, SerialDataReceivedEventArgs e)
        {
            ReadData(inbuffer, totalbyte, timeout);
            this.BeginInvoke(new SetTextDeleg(si_DataReceived), new object[] { inbuffer });
        }
      
        public void WriteToComPort()
        {
            outbuffer[11] = 0xEE;   // indicate the end byte. can overwrite if necessary

            ComPort_RS232.Write(outbuffer, 0, 12);

            label_outbuffer.Text = (outbuffer[0] + " , " + outbuffer[1] + " , " + outbuffer[2] + " , " + outbuffer[3] + " , " + outbuffer[4] + " , " + outbuffer[5] + " , " + outbuffer[6] + " , " + outbuffer[7] + " , " + outbuffer[8] + " , " + outbuffer[9] + " , " + outbuffer[10] + " , " + outbuffer[11]);
        }

        private void si_DataReceived(byte[] inbuffer)
        {
            ResProgramMode = ((int)inbuffer[1] & 0x0F);
           
            if (buttonRxBlink.BackColor == Color.Green)
                buttonRxBlink.BackColor = Color.Yellow;
            else
                buttonRxBlink.BackColor = Color.Green;

            ProcessInBuffer();
        }

        public bool ReadData(byte[] responseBytes, int bytesExpected, int timeOut)
        {
            ComPort_RS232.ReadTimeout = timeOut;
            int offset = 0, bytesRead;

            try
            {
                while (bytesExpected > 0 && (bytesRead = ComPort_RS232.Read(responseBytes, offset, bytesExpected)) > 0)
                {
                    offset += bytesRead;
                    bytesExpected -= bytesRead;
                }
                return bytesExpected == 0;
            }
            catch
            {
                return bytesExpected == 0;
            }

        }

        public void ChangeProgramMode()
        {
            ProgramModeCheckingTimer.Enabled = true;      // check receive acknowledge
            ProgramModeCheckKey = ProgramModeChecking;
            ProgramModeReady = false;

         
                outbuffer[0] = 0x06;
                outbuffer[1] = 0x05;
                outbuffer[2] = Convert.ToByte(SetProgramMode);
         

            tab_DeviceScreen.Visible = true;
            DeviceScreenRemoveAllTabPages();
            WriteToComPort();
        }

        public void DeviceScreenRemoveAllTabPages()
        {

            tab_DeviceScreen.TabPages.Remove(SingleAxis);
            tab_DeviceScreen.TabPages.Remove(DualAxis);
        }

        /****************************************************************************************************************************
         *          PROCESS IN BUFFER HERE                                                                                          *
        ******************************************************************************************************************************/
        private void ProcessInBuffer()
        {
            Mode = (inbuffer[1] & 0x0F);
            switch (Mode)    // Device Mode
            {
                case PM_INIT_STANDALONE:    // Handshaking with sensor module and get the sensor model
                    if (inbuffer[1] == SensorInitCmd)
                        SensorModel = inbuffer[3];

                    if (SensorModel == 0x50 || SensorModel == 0x55)
                    {
                        SensorInitSuccess = true;
                        SensorNotInit = true;
                        ProgramModeReady = true;
                        outbuffer[0] = SensorInitCmd;
                        outbuffer[1] = SensorInitAck;
                        WriteToComPort();
                    }
                    break;

                case PM_ANGLE_SINGLE:
                    label_DeviceStatus.Text = "Device is in Single Axis Mode";
                    Stand = (inbuffer[1] >> 4);
                    if (Stand == 1) // checking stand
                    {
                        int x_Value = (int)(inbuffer[5] << 24) + (int)(inbuffer[4] << 16) + (int)(inbuffer[3] << 8) + inbuffer[2];

                        if (ConnectedModel == 0x50)
                        {
                            RealAngle__X = ((float)(x_Value - 1800000) / ACC_Multiplyer);
                            label_SingleAngleValue.Text = RealAngle__X.ToString("N2") + '°';
                        }
                        else if (ConnectedModel == 0x55)
                        {
                            RealAngle__X = ((float)(x_Value - 18000000) / ACC_Multiplyer);
                            label_SingleAngleValue.Text = RealAngle__X.ToString("N4") + '°';

                        }
                    }
                    else
                    {
                        label_SingleAngleValue.Text = "Error";
                    }
                    break;

                case PM_ANGLE_DUAL:
                    if (AutoChangeScreenAfterCalibration)
                    {
                        AutoChangeScreenAfterCalibration = false;
                        CalibrationTimer.Enabled = false;
                        DeviceScreenRemoveAllTabPages();
                        tab_DeviceScreen.TabPages.Add(DualAxis);
                        groupBoxCalibrationMode.Visible = false;
                        groupBoxCheckingMode.Visible = true;
                        buttonMainModeChecking.Enabled = true;
                        buttonMainModeCalibration.Enabled = false;
                    }
                    if ((inbuffer[1] & 0x0F) == PM_ANGLE_DUAL)
                    {
                        label_DeviceStatus.Text = "Device is in Dual Axis Mode";

                        if (RealAngle__X <= Acc_Zero_Limit && RealAngle__X >= -Acc_Zero_Limit)
                        {
                            label_DualX.ForeColor = Color.LightGreen;
                            ACC_X_Levelled = true;
                        }
                        else
                        {
                            label_DualX.ForeColor = Color.White;
                            ACC_X_Levelled = false;
                        }

                        if (RealAngle__Y <= Acc_Zero_Limit && RealAngle__Y >= -Acc_Zero_Limit)
                        {
                            label_YDual.ForeColor = Color.LightGreen;
                            ACC_Y_Levelled = true;
                        }
                        else
                        {
                            label_YDual.ForeColor = Color.White;
                            ACC_Y_Levelled = false;
                        }

                        if (ConnectedModel == 0x50)
                        {
                            int x_value = (int)(inbuffer[7] << 16) + (int)(inbuffer[6] << 8) + inbuffer[5];
                            RealAngle__X = ((float)(x_value - 300000) / ACC_Multiplyer);

                            int y_value = (int)(inbuffer[4] << 16) + (int)(inbuffer[3] << 8) + inbuffer[2];
                            RealAngle__Y = ((float)(y_value - 300000) / ACC_Multiplyer);

                            label_YDual.Text = RealAngle__Y.ToString("N2") + '°';
                            label_DualX.Text = RealAngle__X.ToString("N2") + '°';
                        }
                        else if (ConnectedModel == 0x55)
                        {
                            int x_value = (int)(inbuffer[7] << 16) + (int)(inbuffer[6] << 8) + inbuffer[5];
                            RealAngle__X = ((float)(x_value - 3000000) / ACC_Multiplyer);

                            int y_value = (int)(inbuffer[4] << 16) + (int)(inbuffer[3] << 8) + inbuffer[2];
                            RealAngle__Y = ((float)(y_value - 3000000) / ACC_Multiplyer);
                            label_YDual.Text = RealAngle__Y.ToString("N4") + '°';
                            label_DualX.Text = RealAngle__X.ToString("N4") + '°';

                        }
                    }
                    else
                    {
                        label_DeviceStatus.Text = "Device is not in Dual Axis Mode";
                        if (ConnectedModel == 0x50)
                        {

                            label_YDual.Text = "Invalid";
                            label_DualX.Text = "Invalid";
                        }
                        else if (ConnectedModel == 0x55)
                        {

                            label_YDual.Text = "Invalid";
                            label_DualX.Text = "Invalid";

                        }
                    }
                    break;

                case PM_VIBRO:
                    if ((inbuffer[1] & 0x0F) == PM_VIBRO)
                    {
                        sensor_vibroValue = (((int)(inbuffer[5] << 24) + (int)(inbuffer[4] << 16) + (int)(inbuffer[3] << 8) + inbuffer[2]) - 250000);
                        vibrograph.ChildVibro_sensor = Parent_Sensor_vibro;
                    }
                    else
                    {
                        Console.WriteLine("is not in vibromode");
                    }
                    break;


                case PM_CALIBRATION:
                    label_DeviceStatus.Text = "Device is in Zero Calibration Mode";

                    Label_LevelCalibrationStepNo.Text = "Calibration Step" + "  " + Convert.ToString(inbuffer[5]) + "  ";
                    label_CalibrationCount.Text = Convert.ToString(30 - inbuffer[3]);

                    if (inbuffer[5] == 4)
                        AutoChangeScreenAfterCalibration = true;

                    if (inbuffer[2] == 10)
                    {
                        buttonCalibrationProceed.Enabled = false;
                        outbuffer[3] = 0x00;    // reset calibration trigger 
                    }
                    else
                        buttonCalibrationProceed.Enabled = true;

                    break;
            }

            label_indata.Text = (inbuffer[0] + " , " + inbuffer[1] + " , " + inbuffer[2] + " , " + inbuffer[3] + " , " + inbuffer[4] + " , " + inbuffer[5] + " , " + inbuffer[6] + " , " + inbuffer[7] + " , " + inbuffer[8] +  " , " + inbuffer[9] + " , " + inbuffer[10] + " , " + inbuffer[11]);
        }

        /*********************************** End of Process In Buffer ********************************************************************/



        /*********************************************************************************************************************************/
        /**************************** Mode Checking Timer ********************************************************************************/
        /*********************************************************************************************************************************/
        private void ProgramModeCheckingTimer_Tick(object sender, EventArgs e)
        {
            switch (ProgramModeCheckKey)
            {
                case ProgramModeChecking:
                    if (SetProgramMode == ResProgramMode)
                    {
                        ProgramModeCheckingTimer.Enabled = false;
                        ProgramModeReady = true;
                    }
                    else
                    {
                        ComPort_RS232.Write(outbuffer, 0, 12);       // Resend previous buffer
                    }
                    break;

            }
        }


        /**************************************************** End of Timer Routines  **************************************************************/
        

        private void buttonMainModeChecking_Click(object sender, EventArgs e)
        {
            groupBoxCheckingMode.Visible = true;
            groupBoxDeviceOperationStatus.Visible = true;
            buttonMainModeCalibration.Enabled = false;
            InitModeCmd = true;
        }

        private void buttonModeSingleAxis_Click(object sender, EventArgs e)
        {

            SetProgramMode = PM_ANGLE_SINGLE;

            outbuffer[3] = 0xEE;
            ChangeProgramMode();
            tab_DeviceScreen.TabPages.Add(SingleAxis);
            
        }

        private void buttonModeDualAxis_Click(object sender, EventArgs e)
        {

            SetProgramMode = PM_ANGLE_DUAL;

            outbuffer[3] = 0xEE;
            ChangeProgramMode();
            tab_DeviceScreen.TabPages.Add(DualAxis);
        }

       
        private void button_ModelSelect_Click(object sender, EventArgs e)
        {
            if (comboBox_Model.Text == "DWL4200XY 0.01")
            {
                ConnectedModel = 0x50;
                ACC_Multiplyer = 10000;
                groupCountrySet.Visible = false;
            }
            else if (comboBox_Model.Text == "DWL4500XY 0.001")
            {
                ConnectedModel = 0x55;
                ACC_Multiplyer = 100000;
                groupCountrySet.Visible = true;
            }
            groupBoxDeviceOperationStatus.Visible = true;
            groupBoxMainProgramMode.Visible = true;
            groupBox_Model.Enabled = false;
        }

        private void label_X_arcsec_Click(object sender, EventArgs e)
        {

        }

        private void btn_calibration_mode_Click(object sender, EventArgs e)
        {

            groupBoxCalibrationMode.Visible = true;
            groupBoxDeviceOperationStatus.Visible = true;
            buttonMainModeChecking.Enabled = false;

        }

        private void buttonModeCalibration_Click(object sender, EventArgs e)
        {
            SetProgramMode = PM_CALIBRATION;
            outbuffer[3] = 0xA0;
            ChangeProgramMode();
            buttonCalibrationProceed.Visible = true;
            tab_DeviceScreen.TabPages.Add(Calibration);
        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void Button_Controlbox_COMPort_Click(object sender, EventArgs e)
        {
            try
            {
                if (!ComPort_RS232.IsOpen)
                {
                    ComPort_RS232.BaudRate = 115200;
                    ComPort_RS232.Parity = Parity.None;
                    ComPort_RS232.DataBits = 8;
                    ComPort_RS232.StopBits = StopBits.One;
                    ComPort_RS232.Handshake = Handshake.None;
                    ComPort_RS232.DataReceived += new SerialDataReceivedEventHandler(sp_DataReceived);
                    ComPort_RS232.Open();

                    COMPortStatus.Text = "Status: Serial Port is ready";

                    groupBox_Model.Visible = true;
                    direct_from_sensor = false;

                    WriteToComPort();
                }
                else
                {
                    comboBox_COMPort_List.Enabled = false;
                }
            }
            catch (Exception ex)
            {
                COMPortStatus.Text = ex.Message;
            }
        }

        private void SelectCountry_Click(object sender, EventArgs e)
        {
            SetProgramMode = PM_LOCATION_SET;

            String CountryInput = txtCountry.Text;
            String CityInput = txtCity.Text;

            
            country_index = Convert.ToInt32(CountryInput, 16);
            city_index = Convert.ToInt32(CityInput, 16);

                outbuffer[3] = (byte)country_index;
                outbuffer[4] = (byte)city_index;
                outbuffer[5] = 0;
                outbuffer[6] = 0;
                outbuffer[7] = 0x5A;

            ChangeProgramMode();
        }

        private void btnVibro_Click(object sender, EventArgs e)
        {
            SetProgramMode = PM_VIBRO;
            outbuffer[1] = 0x01;
            outbuffer[3] = 0xAA;
            ChangeProgramMode();

            vibrograph = new vibrometer();
            vibrograph.Name = "VibroMeter";
            vibrograph.Show();
        }


        public int Parent_Sensor_vibro
        {
            get { return sensor_vibroValue; }
        }
    }
}